//
//  MPSPluginsInstallWindow.h
//  Memphis
//
//  Created by yurk on 9/17/13.
//  Copyright (c) 2013 MacPhun LLC. All rights reserved.
//

#import "MPUserInterface.h"

@protocol MPSPluginsInstallWindow <NSObject>
@required

- (NSString*)applicationName;
- (NSString*)pluginForApplicationName;

@end

@interface MPSPluginsInstallWindow : MPModalWindowController

@property (weak) IBOutlet MPAbstractButton *doneButton;
@property (weak) IBOutlet NSTextField *windowTitleField;
@property (weak) IBOutlet NSTextField *photoshopPluginInstallStatus;
@property (weak) IBOutlet MPAbstractButton *photoshopPluginInstallButton;
@property (weak) IBOutlet NSTextField *photoshopPluginInstallTitle;
@property (weak) IBOutlet NSTextField *lightRoomPluginInstallStatus;
@property (weak) IBOutlet MPAbstractButton *lightRoomPluginInstallButton;
@property (weak) IBOutlet NSTextField *lightRoomPluginInstallTitle;
@property (weak) IBOutlet NSTextField *aperturePluginInstallStatus;
@property (weak) IBOutlet MPAbstractButton *aperturePluginInstallButton;
@property (weak) IBOutlet NSTextField *aperturePluginInstallTitle;
@property (weak) IBOutlet NSTextField *elementsInstallStatus;
@property (weak) IBOutlet MPAbstractButton *elementsInstallButton;
@property (weak) IBOutlet NSTextField *elementsPluginInstallTitle;
@property (weak) IBOutlet NSProgressIndicator *progressIndicator;
@property (weak) IBOutlet NSTextField *operationNameField;
@property (weak) IBOutlet NSView *taskView;
@property (weak) IBOutlet NSProgressIndicator *installPhotoshopProgress;
@property (weak) IBOutlet NSProgressIndicator *installLightroomProgress;
@property (weak) IBOutlet NSProgressIndicator *installApertureProgress;
@property (weak) IBOutlet NSProgressIndicator *installElementsProgress;
@property (weak) IBOutlet NSButton *closeButton;
@property (weak) IBOutlet NSImageView *photoshopIconView;
@property (weak) IBOutlet NSImageView *lightroomIconView;
@property (weak) IBOutlet NSImageView *apertureIconView;
@property (weak) IBOutlet NSImageView *elementsIconView;

//+ (id)sharedPane;
- (id)initWithApplicationName:(NSString*)applicationName pluginAppName:(NSString*)pluginAppName
			applicationUUID:(NSString *)uuid;
- (id)initWithUUID:(NSString *)uuid;

- (void)chekAndReinstallPluginsIfNeedsForWindow:(NSWindow *)aWindow;
- (void)startForWindow:(NSWindow *)aWindow;
- (void)startForWindow:(NSWindow *)aWindow completion:(void(^)())completion;
+ (void)checkIfNeedsForApplicationWithName:(NSString *)applicationName pluginAppName:(NSString *)pluginAppName
			applicationUUID:(NSString *)uuid window:(NSWindow *)window;

@end

extern NSString *const kPluginInstalledMsg;
extern NSString *const kPluginNotInstalledMsg;
extern NSString *const kInstallButtonTitle;
extern NSString *const kUninstallButtonTitle;
extern NSString *const kLastCheckedVersionKey;
extern NSString *const kNotFirstCheckKey;
extern NSString *const kSoftwareNotInstalledMsg;